import 'package:dartz/dartz.dart';
import 'package:razinsoft_rider/data/models/common_response.dart';
import 'package:razinsoft_rider/data/models/my_card_model/my_card_model.dart';
import '../../core/errors/failure.dart';
import '../../domain/interfaces/wallet_service_interface.dart';
import '../models/wallet_model/wallet_model.dart';
import 'base_repository.dart';
import 'interfaces/wallet_repo_interface.dart';

class WalletsRepoImpl extends BaseRepository implements IWalletsRepo {
  final IWalletService walletService;

  WalletsRepoImpl({required this.walletService});
  @override
  Future<Either<Failure, WalletModel>> getWallets() async => await safeApiCall(() async {
      final response = await walletService.getWallets();
      return WalletModel.fromJson(response.data);
    });

  @override
  Future<Either<Failure, WalletModel>> addBalance({required String amount}) async => await safeApiCall(() async {
      final response = await walletService.addBalance(amount: amount);
      return WalletModel.fromJson(response.data);
    });

  @override
  Future<Either<Failure, CommonResponse>> addCard({required Map<String, dynamic> body}) async => await safeApiCall(() async {
      final response = await walletService.addCard(body: body);
      return CommonResponse.fromMap(response.data);
    });

  @override
  Future<Either<Failure, MyCardModel>> myCards() async => await safeApiCall(() async {
      final response = await walletService.myCards();
      return MyCardModel.fromJson(response.data);
    });

  @override
  Future<Either<Failure, CommonResponse>> deleteCard({required String? id}) async => await safeApiCall(() async {
      final response = await walletService.deleteCard(id);
      return CommonResponse.fromMap(response.data);
    });
}
